/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	EditorInterface
**
** DESCRIPTION:	Interface for editor modules
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef EDITOR_INTERFACE_H
#define EDITOR_INTERFACE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class IEditor
{
	//interface methods
	//setup
	public:		virtual void Reset() = 0;

	// process
	public:		virtual void Draw() = 0;
	public:		virtual const bool HandleKeyCharacter(const char cKey) = 0;
	public:		virtual const bool HandleKeyDown(const int iKeyCode) = 0;
	public:		virtual const bool HandleKeyUp(const int iKeyCode) = 0;
	public:		virtual const bool HandleMouseDown(const ldwPoint sMousePos) = 0;
	public:		virtual const bool HandleMouseUp(const ldwPoint sMousePos) = 0;
	public:		virtual const bool HandleMouseMove(const ldwPoint sMousePos) = 0;

	// access
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/